plotlinewidth=4;
markersize=4;

figure;
colors = get(gca,'ColorOrder')
close

% start=[3*10^(-4);guess_maximum; 0; 10];
% up = [1;guess_maximum*1.05;+5; 200];
% low = [0.000001;guess_maximum*0.95;0.0; 5];%d?mpfung, resonanzfrequenz,y-offset, peak-h?he

start=[100;guess_maximum; 10000; 0];
up = [10000;guess_maximum*1.05;5E10; 0.00001];
low = [0.001;guess_maximum*0.95;1; 0];%d?mpfung, resonanzfrequenz,y-offset, peak-h?he


%,'Display','iter'
[val_low, index_low]=min(abs(result_frequency(:)-guess_maximum*0.7));
[val_up, index_up]=min(abs(result_frequency(:)-guess_maximum*1.4));
optionsforfit = fitoptions('Method', 'NonlinearLeastSquares','MaxIter',200,'TolFun',10^-10,'TolX',10^-10,'Upper',up,'Lower',low,'StartPoint',start);

%typeoffit = fittype('d*(a*b)^2/((x-b)^2+(a*x)^2) + c', 'options', optionsforfit);

typeoffit = fittype('c/((x^2-b^2)^2+(2*a*x)^2)+d', 'options', optionsforfit);

fitobject=fit(result_frequency(index_low:index_up)',double_result_amplitude(index_low:index_up)',typeoffit);
%fitobject=fit(transpose(data(dampnr,index_low:index_up,1)),transpose(data(dampnr,index_low:index_up,2)),typeoffit);
x=linspace(100,160,1000);
coeff=coeffvalues(fitobject);
a=coeff(1);
b=coeff(2);
c=coeff(3);
d=coeff(4);

FWHM1=2*sqrt(a^2*b^2 + 2*a^4*b^2)/(1 + a^2);
f_res1=b;
Q1=f_res1/(2*a);
D1=1/(2*Q);

hold on

%plot(x,d*(a*b).^2./((x-b).^2+(a*x).^2) + c,'LineWidth',1.8,'color',colors(1,:))
plot(x,c./((x.^2-b^2).^2+(2*a*x).^2)+d,'LineWidth',1.8,'color',colors(1,:))
plot(result_frequency(index_low:index_up)',double_result_amplitude(index_low:index_up)','o','MarkerSize',markersize,'color',colors(2,:))


dim = [.2 .74 .8 .15];
%annotation('textbox',dim,'String',['f_0=', num2str(b,7),' kHz', newline , 'FWHM=', num2str(FWHM,3), ' kHz', newline,'Q=',num2str(Q,4), newline , 'D=', num2str(D,3)],'FitBoxToText','on');

ylabel('$(A/A_0)^2$ ','interpreter','latex') 

if plot_counter==3;
    fit_result_amplitude=[a b c d];
    save('fit_result_amplitude.dat'  ,  'fit_result_amplitude', '-ascii' ,'-tabs');
    amplitude_fit=c./((x.^2-b^2).^2+(2*a*x).^2)+d
    save('amplitude_fit.dat'  ,  'amplitude_fit', '-ascii' ,'-tabs');
    save('x_amplitude.dat'  ,  'x', '-ascii' ,'-tabs');
end

hold off
